import { getDefaultCdnBaseUrl } from "@tldraw/editor";
import { useMemo } from "react";
let defaultEditorAssetUrls = {
  fonts: {
    draw: `${getDefaultCdnBaseUrl()}/fonts/Shantell_Sans-Tldrawish.woff2`,
    serif: `${getDefaultCdnBaseUrl()}/fonts/IBMPlexSerif-Medium.woff2`,
    sansSerif: `${getDefaultCdnBaseUrl()}/fonts/IBMPlexSans-Medium.woff2`,
    monospace: `${getDefaultCdnBaseUrl()}/fonts/IBMPlexMono-Medium.woff2`
  }
};
function setDefaultEditorAssetUrls(assetUrls) {
  defaultEditorAssetUrls = assetUrls;
}
function useDefaultEditorAssetsWithOverrides(overrides) {
  return useMemo(() => {
    if (!overrides) return defaultEditorAssetUrls;
    return {
      fonts: { ...defaultEditorAssetUrls.fonts, ...overrides?.fonts }
    };
  }, [overrides]);
}
export {
  defaultEditorAssetUrls,
  setDefaultEditorAssetUrls,
  useDefaultEditorAssetsWithOverrides
};
//# sourceMappingURL=assetUrls.mjs.map
